//<?php
/**
 * CKEditor
 *
 * CKEditor - RichText Editor Plugin
 *
 * @category 	plugin
 * @version 	3.5.2
 * @license 	http://www.gnu.org/copyleft/gpl.html GNU Public License (GPL)
 * @internal	@properties &format_tags=Format selector;text; &height=height;text;
 *
 * @internal	@events OnRichTextEditorInit, OnRichTextEditorRegister, OnInterfaceSettingsRender
 * @internal	@modx_category Manager and Admin
 *
 *
 * Original Written By Jeff Whitfield - April 30, 2007
 * Modify By yama - 2011-03-15
 */

// Set the name of the plugin folder
$cke_dir = "ckeditor";

// Set path and base setting variables
if(!isset($cke_path))
{
	$cke_path = MODX_BASE_PATH . 'assets/plugins/' . $cke_dir . '/'; 
}
include_once $cke_path . 'functions.php';
		$params['manager_language'] = $modx->config['manager_language'];
		$params['use_editor']       = $modx->config['use_editor'];
		$params['format_tags']      = $format_tags;
		$params['elements']         = $elements;
		$params['width']            = $width;
		$params['height']           = (!empty($height)) ? str_replace('px', '', $height) .'px' : '300px';
		$params['editor_css_path']  = '';
//		$params['editor_css_path']  = $modx->config['editor_css_path'];
		$params['cke_dir']          = $cke_dir;
		$params['cke_path']         = $cke_path;

// Handle event
$e = &$modx->Event; 
switch ($e->name)
{ 
	case "OnRichTextEditorRegister": // register only for backend
		$e->output("CKEditor");
		break;

	case "OnRichTextEditorInit": 
		if($editor!=='CKEditor') return;
		
		$cke = new CKEditor($params);
		
		$params['language']        = $ck_language;
			$params['use_browser']     = $modx->config['use_browser'];
		
		if($modx->isBackend() || (intval($_GET['quickmanagertv']) == 1 && isset($_SESSION['mrgValidated'])))
		{
			$ck_language = $cke->get_cke_lang($modx->config['manager_language']);
			
			$params['toolbarset']      = (!empty($modx->config['ck_editor_toolbar']) ? $modx->config['ck_editor_toolbar']:"modx");
			$params['toolbarcustom']   = (!empty($modx->config['ck_editor_custom_toolbar']) && ($modx->config['ck_editor_toolbar'] == "custom") ? $modx->config['ck_editor_custom_toolbar']:"");
			$params['frontend']        = false;
			$params['autoLang']        = $modx->config['ck_editor_autolang'];
			$params['webuser']         = null;
			
			$html = $cke->get_cke_script($params);
		}
		else
		{
			$frontend_language = isset($modx->config['fe_editor_lang']) ? $modx->config['fe_editor_lang']:"";
			$ck_language = $cke->get_cke_lang($frontend_language);
			$webuser = (isset($modx->config['rb_webuser']) ? $modx->config['rb_webuser'] : null);
			
			$params['toolbarset']      = (isset($ckwebset) ? $ckwebset: 'basic');
			$params['toolbarcustom']   = (isset($ckwebcustom) && ($ckwebset == 'custom') ? $ckwebcustom : '');
			$params['frontend']        = true;
			$params['autoLang']        = $ckwebautolang;
			$params['webuser']         = $webuser;
			
			$html = $cke->get_cke_script($params);
		}
		$e->output($html);
		break;

	case "OnInterfaceSettingsRender":
		
		$cke = new CKEditor($params);
		$params['toolbarset']       = $modx->config['ck_editor_toolbar'];
		$params['toolbarcustom']    = $modx->config['ck_editor_custom_toolbar'];
		$params['autolang']         = $modx->config['ck_editor_autolang'];
		
		$html = $cke->get_cke_settings($params);
		$e->output($html);
		break;

   default :    
      return;
}
